<?php

namespace Fooman\PdfCustomiser\Model;

class DefaultDesign implements Api\DesignInterface
{
    private $defaultTemplateFiles = [
        'logo' => 'Fooman_PdfCore::pdf/logo.phtml',
        'table' => 'Fooman_PdfCore::pdf/table.phtml',
        'shipping' => 'Fooman_PdfCustomiser::pdf/shipping.phtml',
        'comments' => 'Fooman_PdfCustomiser::pdf/comments.phtml',
        'giftmessage' => 'Fooman_PdfCustomiser::pdf/giftmessage.phtml',
        'taxTable' => 'Fooman_PdfCustomiser::pdf/taxtable.phtml',
        'totals' => 'Fooman_PdfCustomiser::pdf/totals.phtml',
        'bundleExtras' => 'Fooman_PdfCustomiser::pdf/table/bundle-extras.phtml',
        'extras' => 'Fooman_PdfCustomiser::pdf/table/extras.phtml'
    ];

    public function getLayoutHandle($pdfType)
    {
        return sprintf('fooman_pdfcustomiser_%s', $pdfType);
    }

    /**
     * @return array
     */
    public function getItemStyling()
    {
        return [
            'header' => [
                'default' => 'border-bottom:1px solid black;',
                'first' => 'border-bottom:1px solid black;',
                'last' => 'border-bottom:1px solid black;'
            ],
            'row' => [
                'default' => 'border-bottom:0px none transparent;',
                'last' => 'border-bottom:0px solid black;',
                'first' => 'border-bottom:0px none transparent;'
            ],
            'table' => ['default' => 'padding: 2px 0px;']
        ];
    }

    public function getTemplateFiles()
    {
        return $this->defaultTemplateFiles;
    }
}