<?php
/**
 * @author     Kristof Ringleff
 * @package    Fooman_PdfCustomiser
 * @copyright  Copyright (c) 2015 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\PdfCustomiser\Model;

class DesignProvider
{

    /**
     * @var DesignDecider
     */
    private $designDecider;

    /**
     * @var PdfDesignFactory
     */
    private $designFactory;

    public function __construct(
        DesignDecider $designDecider,
        PdfDesignFactory $pdfDesignFactory
    ) {
        $this->designDecider = $designDecider;
        $this->designFactory = $pdfDesignFactory;
    }

    /**
     * @param       $storeId
     * @param array $templateVars
     *
     * @return Api\DesignInterface
     */
    public function getDesign($storeId, array $templateVars = [])
    {
        $design = $this->designDecider->pick($storeId, $templateVars);
        return $this->designFactory->get($design);
    }
}