<?php
/**
 * @author     Kristof Ringleff
 * @package    Fooman_PdfCore
 * @copyright  Copyright (c) 2015 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\PdfCore\Helper;

use Magento\Framework\Filesystem;
use Magento\Framework\App\Area;
use Magento\Framework\View\DesignInterface;

class BackgroundImage
{

    /**
     * @var FileOps
     */
    private $file;

    /**
     * @var Filesystem
     */
    private $filesystem;

    /**
     * @var DesignInterface
     */
    private $design;

    const XML_PATH_BACKGROUND_IMAGE = 'sales_pdf/all/page/allbgimage';
    const XML_PATH_NO_BG_IN_ADMIN = 'sales_pdf/all/page/nobginadmin';

    /**
     * @param FileOps         $file
     * @param Filesystem      $filesystem
     * @param DesignInterface $design
     */
    public function __construct(
        FileOps $file,
        Filesystem $filesystem,
        DesignInterface $design
    ) {
        $this->file = $file;
        $this->filesystem = $filesystem;
        $this->design = $design;
    }

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param                                                    $storeId
     *
     * @return bool|string
     */
    public function getBackgroundImageFilePath(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        $storeId
    ) {

        $suppressAdmin = $scopeConfig->isSetFlag(
            self::XML_PATH_NO_BG_IN_ADMIN,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $storeId
        );

        if ($suppressAdmin && $this->design->getArea() === Area::AREA_ADMINHTML) {
            return false;
        }

        $file = $scopeConfig->getValue(
            self::XML_PATH_BACKGROUND_IMAGE,
            \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
            $storeId
        );
        $fullPath = $this->filesystem->getDirectoryRead(\Magento\Framework\App\Filesystem\DirectoryList::MEDIA)
            ->getAbsolutePath('pdf_background/' . $file);
        if ($this->file->fileExists($fullPath)) {
            return $fullPath;
        }
        return false;
    }
}
