<?php
/**
 * @author     Kristof Ringleff
 * @package    Fooman_PdfCore
 * @copyright  Copyright (c) 2015 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\PdfCore\Block\Pdf\Column;

use \Magento\Sales\Api\Data\OrderItemInterface;

class Subtotal extends \Fooman\PdfCore\Block\Pdf\Column implements \Fooman\PdfCore\Block\Pdf\ColumnInterface
{
    const DEFAULT_WIDTH = 12;
    const DEFAULT_TITLE = 'Subtotal';
    const COLUMN_TYPE = 'fooman_currency';

    public function getGetter()
    {
        return [$this, 'getSubtotal'];
    }

    public function getSubtotal($row)
    {
        $property = OrderItemInterface::ROW_TOTAL_INCL_TAX;
        $baseProperty = OrderItemInterface::BASE_ROW_TOTAL_INCL_TAX;

        $subtotal = call_user_func([$row, $this->convertInterfaceConstantToGetter($property)]);
        $baseSubtotal = call_user_func([$row, $this->convertInterfaceConstantToGetter($baseProperty)]);

        if (null === $subtotal) {
            $property = OrderItemInterface::ROW_TOTAL;
            $baseProperty = OrderItemInterface::BASE_ROW_TOTAL;
            $subtotal = call_user_func([$row, $this->convertInterfaceConstantToGetter($property)]);
            $baseSubtotal = call_user_func([$row, $this->convertInterfaceConstantToGetter($baseProperty)]);

            $taxProperty = OrderItemInterface::TAX_AMOUNT;
            $baseTaxProperty = OrderItemInterface::BASE_TAX_AMOUNT;

            $subtotal += call_user_func([$row, $this->convertInterfaceConstantToGetter($taxProperty)]);
            $baseSubtotal += call_user_func([$row, $this->convertInterfaceConstantToGetter($baseTaxProperty)]);
        }

        if ($this->isDisplayingBothCurrencies()) {
            return [
                ['currency' => $this->getBaseCurrencyCode(), 'amount' => $baseSubtotal],
                ['currency' => $this->getCurrencyCode(), 'amount' => $subtotal]
            ];
        } elseif ($this->getUseOrderCurrency()) {
            return $subtotal;
        }
        return $baseSubtotal;
    }
}
