<?php
/**
 * @author     Kristof Ringleff
 * @package    Fooman_PdfCustomiser
 * @copyright  Copyright (c) 2009 Fooman Limited (http://www.fooman.co.nz)
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Fooman\PdfCustomiser\Controller\Adminhtml\Invoice;

use Magento\Framework\Data\Collection;
use Magento\Framework\Controller\ResultFactory;

class Pdfinvoices extends \Magento\Backend\App\Action
{
    /**
     * @var string
     */
    private $redirectUrl = 'sales/order_invoice/index';

    /**
     * @var \Fooman\PdfCustomiser\Block\InvoiceFactory
     */
    private $invoiceDocumentFactory;

    /**
     * @var \Magento\Ui\Component\MassAction\Filter
     */
    private $filter;
    
    /**
     * @var \Fooman\PdfCore\Model\Response\Http\FileFactory
     */
    private $pdfFileHandling;

    /**
     * @var \Fooman\PdfCore\Model\PdfRenderer
     */
    private $pdfRenderer;

    /**
     * @var \Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory
     */
    private $collectionFactory;

    /**
     * @param \Magento\Backend\App\Action\Context                                $context
     * @param \Magento\Ui\Component\MassAction\Filter                            $filter
     * @param \Fooman\PdfCore\Model\PdfFileHandling                              $pdfFileHandling
     * @param \Fooman\PdfCore\Model\PdfRenderer                                  $pdfRenderer
     * @param \Fooman\PdfCustomiser\Block\InvoiceFactory                         $invoiceDocumentFactory
     * @param \Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory $invoiceCollectionFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Ui\Component\MassAction\Filter $filter,
        \Fooman\PdfCore\Model\PdfFileHandling $pdfFileHandling,
        \Fooman\PdfCore\Model\PdfRenderer $pdfRenderer,
        \Fooman\PdfCustomiser\Block\InvoiceFactory $invoiceDocumentFactory,
        \Magento\Sales\Model\ResourceModel\Order\Invoice\CollectionFactory $invoiceCollectionFactory
    ) {
        $this->invoiceDocumentFactory = $invoiceDocumentFactory;
        $this->collectionFactory = $invoiceCollectionFactory;
        $this->filter = $filter;
        $this->pdfFileHandling = $pdfFileHandling;
        $this->pdfRenderer = $pdfRenderer;
        parent::__construct($context);
    }

    /**
     * Print selected invoices
     *
     * @return \Magento\Framework\App\ResponseInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Exception
     */
    public function execute()
    {
        $collection = $this->filter->getCollection($this->collectionFactory->create());
        $this->processCollection($collection);

        if ($this->pdfRenderer->hasPrintContent()) {
            return $this->pdfFileHandling->sendPdfFile($this->pdfRenderer);
        }

        $this->messageManager->addErrorMessage(__('Nothing to print'));
        $resultRedirect = $this->resultFactory->create(ResultFactory::TYPE_REDIRECT);
        return $resultRedirect->setPath($this->redirectUrl);
    }

    /**
     * @return bool
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Magento_Sales::sales_invoice');
    }

    /**
     * Print selected invoices
     *
     * @param Collection $collection
     *
     * @return void
     */
    public function processCollection(Collection $collection)
    {
        foreach ($collection->getItems() as $invoice) {
            $document = $this->invoiceDocumentFactory->create(
                ['data' => ['invoice' => $invoice]]
            );

            $this->pdfRenderer->addDocument($document);
        }
    }
}
