<?php

namespace Fooman\PdfCustomiser\Model;

class AlternativeDesign implements Api\DesignInterface
{
    public function getLayoutHandle($pdfType)
    {
        return sprintf('fooman_pdfcustomiser_alt_%s', $pdfType);
    }

    /**
     * @return array
     */
    public function getItemStyling()
    {
        return [
            'header' => [
                'default' => 'border-bottom:1px solid black;',
                'first'   => 'border-bottom:1px solid black;',
                'last'    => 'border-bottom:1px solid black;'
            ],
            'row'    => [
                'default' => 'border-bottom:0px none transparent;',
                'last'    => 'border-bottom:0px solid black;',
                'first'   => 'border-bottom:0px none transparent;'
            ],
            'table'  => ['default' => 'padding: 8px 0px;']
        ];
    }

    public function getTemplateFiles()
    {
        return [
            'table'=>'Fooman_PdfCustomiser::pdf-alt/table.phtml'
        ];
    }
}